﻿//////////////////////////////////////////////
// Pass.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class System ;
	class TargetOperations ;
}

/// Includes ---------------------------------

// nkGraphics
#include "PassType.h"

#include "../Dll/DllDefines.h"

#include "../Profiling/ProfilableClass.h"

// nkExport
#include <NilkinsExport/Exportable/Exportable.h>

// nkMemory
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT Pass : public ProfilableClass, public nkExport::Exportable
	{
		public :

			// Constructor
			Pass (System* system) noexcept ;

			// Getters
			System* getSystem () const ;
			TargetOperations* getParent () const ;
			PASS_TYPE getType () const ;
			nkMemory::StringView getName () const ;

			// Setters
			void setParent (TargetOperations* parent) ;
			void setName (nkMemory::StringView name) ;

			// Import / Export
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		protected :
		
			// Attributes
			System* _system ;

			// Parent operations
			TargetOperations* _parent ;

			// Pass type overwritten by implementations
			PASS_TYPE _type ;

			// A name to debug if required
			nkMemory::String _name ;
	} ;
}